package gov.va.med.mhv.usermgmt.common.enums;

/**
 * Enumeration ActivityActorTypeEnumeration 
 *
 */
public enum ActivityActorTypeEnumeration {

	EVERYONE("Everyone"),
	EVERYONE_BUT_SELF("Everyone But Self"),
	SELF("Self"),
	HEALTHCARE_PROXY_FULL("Healthcare Proxy: Full"),
	HEALTHCARE_PROXY_READ("Healthcare Proxy: Read"),
	HELP_DESK_ADMINISTRATOR("Help Desk Administrator"),
	MHV_AUTHENTICATOR("MHV Authenticator"),
	PERSONAL_REPRESENTATIVE("Personal Representative"),
	UNKNOWN("Unknown"),
	SYSTEM("System");
	
	private String description;
	
	ActivityActorTypeEnumeration(String desc){
		description = desc;
	}
	
	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	
	public static ActivityActorTypeEnumeration fromString(String desc) {
	    if (desc != null) {
	      for (ActivityActorTypeEnumeration activityActorTypeEnum : ActivityActorTypeEnumeration.values()) {
	        if (desc.equalsIgnoreCase(activityActorTypeEnum.description)) {
	          return activityActorTypeEnum;
	        }
	      }
	    }
	    return null;
	  }
}
